/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.common.ExternalLinksUtils;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.common.version.VersionUtils;
import info.msxlaunchers.openmsx.game.repository.RepositoryData;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterFactory;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Medium;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.log.LogEvent;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistence;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterSetNotFoundException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.starter.EmulatorStarter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ActivityViewerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.BlueMSXLauncherDatabasesImporterPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseManagerPresenterFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DraggedAndDroppedGamesPresenterFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.FeedServicePresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.FilterEditingPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.GameLabel;
import info.msxlaunchers.openmsx.launcher.ui.presenter.GamePropertiesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LHAExtractorPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MachineUpdatePresenterFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MoveGameActionDecider;
import info.msxlaunchers.openmsx.launcher.ui.presenter.PatcherPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ProfileEditingPresenterFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.RelatedGamesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ScannerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.SettingsPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.UpdateCheckerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.MainView;
import info.msxlaunchers.platform.FileLocator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@Singleton
final class MainPresenterImpl
implements MainPresenter {
    private final MainView view;
    private final Provider<SettingsPresenter> settingsPresenterFactory;
    private final ProfileEditingPresenterFactory profileEditingPresenterFactory;
    private final Provider<ScannerPresenter> scannerPresenterFactory;
    private final Provider<FilterEditingPresenter> filterEditingPresenterFactory;
    private final Provider<GamePropertiesPresenter> gamePropertiesPresenterFactory;
    private final Provider<BlueMSXLauncherDatabasesImporterPresenter> blueMSXLauncherImporterPresenterFactory;
    private final DatabaseManagerPresenterFactory databaseManagerPresenterFactory;
    private final Provider<UpdateCheckerPresenter> updateCheckerPresenterFactory;
    private final LauncherPersistence launcherPersistence;
    private final EmulatorStarter emulatorStarter;
    private final ExtraDataGetter extraDataGetter;
    private final String helpFileDirectory;
    private final RepositoryData repositoryData;
    private final FileLocator fileLocator;
    private final DraggedAndDroppedGamesPresenterFactory draggedAndDroppedGamesPresenterFactory;
    private final Provider<ActivityViewerPresenter> activityViewerPresenterFactory;
    private final Provider<PatcherPresenter> patcherPresenterFactory;
    private final MachineUpdatePresenterFactory machineUpdatePresenterFactory;
    private final FeedServicePresenter feedServicePresenter;
    private final Provider<RelatedGamesPresenter> relatedGamesPresenterFactory;
    private final Provider<LHAExtractorPresenter> lhaExtractorPresenterFactory;
    private static final String SCREENSHOT_EXT = ".png";
    private static final String SCREENSHOT1_SUFFIX = "a";
    private static final String SCREENSHOT2_SUFFIX = "b";
    private static final String DEFAULT_SYSTEM_LANGUAGE = "SYSTEM_DEFAULT";
    private static final int MAX_SEARCH_MATCHES = 10;
    private Settings settings;
    private Language currentLanguage;
    private String currentLanguageCode;
    private boolean currentRightToLeft;
    private boolean showUpdateAllDatabases;
    private Set<String> databases = null;
    private String currentDatabase = null;
    private Map<String, Game> gamesMap = null;
    private String openMSXMachinesFullPath = null;
    private Map<String, RepositoryGame> repositoryInfoMap;
    private Set<Filter> currentFilter = null;
    private String currentFilterName = null;
    private boolean untitledFilter = false;
    private boolean filterEditMode = false;

    @Inject
    MainPresenterImpl(MainView view, Provider<SettingsPresenter> settingsPresenterFactory, ProfileEditingPresenterFactory profileEditingFactory, Provider<ScannerPresenter> scannerPresenterFactory, Provider<FilterEditingPresenter> filterEditingPresenterFactory, Provider<GamePropertiesPresenter> gamePropertiesPresenterFactory, Provider<BlueMSXLauncherDatabasesImporterPresenter> blueMSXLauncherImporterPresenterFactory, DatabaseManagerPresenterFactory databaseManagerPresenterFactory, Provider<ActivityViewerPresenter> activityViewerPresenterFactory, Provider<UpdateCheckerPresenter> updateCheckerPresenterFactory, LauncherPersistence launcherPersistence, EmulatorStarter emulatorStarter, ExtraDataGetter extraDataGetter, @Named(value="LauncherDataDirectory") String extraDataDirectory, RepositoryData repositoryData, FileLocator fileLocator, DraggedAndDroppedGamesPresenterFactory draggedAndDroppedGamesPresenterFactory, Provider<PatcherPresenter> patcherPresenterFactory, MachineUpdatePresenterFactory machineUpdatePresenterFactory, FeedServicePresenter feedServicePresenter, Provider<RelatedGamesPresenter> relatedGamesPresenterFactory, Provider<LHAExtractorPresenter> lhaExtractorPresenterFactory) throws IOException {
        this.view = Objects.requireNonNull(view);
        this.settingsPresenterFactory = Objects.requireNonNull(settingsPresenterFactory);
        this.profileEditingPresenterFactory = Objects.requireNonNull(profileEditingFactory);
        this.scannerPresenterFactory = Objects.requireNonNull(scannerPresenterFactory);
        this.filterEditingPresenterFactory = Objects.requireNonNull(filterEditingPresenterFactory);
        this.gamePropertiesPresenterFactory = Objects.requireNonNull(gamePropertiesPresenterFactory);
        this.blueMSXLauncherImporterPresenterFactory = Objects.requireNonNull(blueMSXLauncherImporterPresenterFactory);
        this.databaseManagerPresenterFactory = Objects.requireNonNull(databaseManagerPresenterFactory);
        this.updateCheckerPresenterFactory = Objects.requireNonNull(updateCheckerPresenterFactory);
        this.launcherPersistence = Objects.requireNonNull(launcherPersistence);
        this.emulatorStarter = Objects.requireNonNull(emulatorStarter);
        this.extraDataGetter = Objects.requireNonNull(extraDataGetter);
        this.helpFileDirectory = extraDataDirectory;
        this.repositoryData = Objects.requireNonNull(repositoryData);
        this.fileLocator = Objects.requireNonNull(fileLocator);
        this.draggedAndDroppedGamesPresenterFactory = Objects.requireNonNull(draggedAndDroppedGamesPresenterFactory);
        this.activityViewerPresenterFactory = Objects.requireNonNull(activityViewerPresenterFactory);
        this.patcherPresenterFactory = Objects.requireNonNull(patcherPresenterFactory);
        this.machineUpdatePresenterFactory = Objects.requireNonNull(machineUpdatePresenterFactory);
        this.feedServicePresenter = Objects.requireNonNull(feedServicePresenter);
        this.relatedGamesPresenterFactory = Objects.requireNonNull(relatedGamesPresenterFactory);
        this.lhaExtractorPresenterFactory = Objects.requireNonNull(lhaExtractorPresenterFactory);
        try {
            launcherPersistence.initialize();
        }
        catch (LauncherPersistenceException lpe) {
            LauncherLogger.logException(this, lpe);
            throw new IOException();
        }
        try {
            this.settings = launcherPersistence.getSettingsPersister().getSettings();
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw ioe;
        }
        this.setLanguageParameters(this.settings.getLanguage());
        this.databases = launcherPersistence.getGamePersister().getDatabases().stream().collect(Collectors.toCollection(() -> new TreeSet((db1, db2) -> db1.compareToIgnoreCase((String)db2))));
        String defaultDatabase = this.settings.getDefaultDatabase();
        if (defaultDatabase == null) {
            if (!this.databases.isEmpty()) {
                this.currentDatabase = this.databases.iterator().next();
            }
        } else if (this.databases.contains(defaultDatabase)) {
            this.currentDatabase = defaultDatabase;
        }
        if (this.currentDatabase != null) {
            try {
                this.retrieveDatabaseGames();
            }
            catch (GamePersistenceException gpe) {
                LauncherLogger.logException(this, gpe);
            }
        }
        this.showUpdateAllDatabases = this.settings.isShowUpdateAllDatabases();
        if (this.settings.isEnableFeedService()) {
            this.feedServicePresenter.startService();
        }
        this.openMSXMachinesFullPath = this.settings.getOpenMSXMachinesFullPath();
        this.initializeRepositoryInfoMap();
    }

    @Override
    public void start() {
        this.view.displayMain(this.currentLanguage, this.getSortedGameList(), this.databases, this.currentDatabase, this.currentRightToLeft, this.showUpdateAllDatabases, this.settings.isEnableFeedService());
    }

    @Override
    public void onRequestSettingsScreen() {
        ((SettingsPresenter)this.settingsPresenterFactory.get()).onRequestSettingsScreen(this.settings, this.launcherPersistence.getGamePersister().getDatabases(), this.currentLanguage, this.currentLanguageCode, this.currentRightToLeft);
    }

    @Override
    public void onAcceptSettingsAction(Settings newSettings) throws LauncherException {
        Settings oldSettings = this.settings;
        this.settings = newSettings;
        if (!Utils.equalStrings(this.openMSXMachinesFullPath, this.settings.getOpenMSXMachinesFullPath())) {
            this.openMSXMachinesFullPath = this.settings.getOpenMSXMachinesFullPath();
            this.initializeRepositoryInfoMap();
        }
        Language oldLanguage = oldSettings.getLanguage();
        Language newLanguage = this.settings.getLanguage();
        if (oldLanguage == null && newLanguage != null || oldLanguage != null && newLanguage == null || oldLanguage != null && newLanguage != null && !oldLanguage.equals(newLanguage)) {
            boolean oldRightToLeft = this.currentRightToLeft;
            this.setLanguageParameters(newLanguage);
            if (oldRightToLeft && Language.isLeftToRight(this.currentLanguage)) {
                this.view.flipOrientationLeftToRight();
            } else if (Language.isRightToLeft(this.currentLanguage) && !oldRightToLeft) {
                this.view.flipOrientationRightToLeft();
            }
            this.view.refreshLanguage(this.currentLanguage);
            if (this.untitledFilter) {
                this.view.setFilterNameLabelUntitled();
                this.view.displayFilterDetails(FilterFactory.getFilterMonikers(this.currentFilter));
            }
        }
        if (newSettings.isEnableFeedService()) {
            this.feedServicePresenter.startService();
        } else {
            this.feedServicePresenter.stopService();
        }
        this.view.enableFeedAccess(newSettings.isEnableFeedService());
    }

    @Override
    public void onSelectDatabase(String database) throws LauncherException {
        if (database != null && !database.equals(this.currentDatabase)) {
            this.currentDatabase = database;
            this.populateGameList();
        }
    }

    @Override
    public void onLaunchGame(String gameName) throws LauncherException {
        try {
            this.emulatorStarter.start(this.settings, this.gamesMap.get(gameName));
            LauncherLogger.logMessage(LogEvent.LAUNCH, gameName + "[" + this.currentDatabase + "]");
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_START_OPENMSX);
        }
    }

    @Override
    public void onRequestAddGameScreen() throws LauncherException {
        if (this.currentDatabase != null) {
            this.profileEditingPresenterFactory.create(this.settings, this.currentDatabase, null).onRequestAddGameScreen(this.currentLanguage, Language.isRightToLeft(this.currentLanguage));
        }
    }

    @Override
    public void onRequestEditGameScreen(String gameName) throws LauncherException {
        Game game = this.gamesMap.get(gameName);
        this.profileEditingPresenterFactory.create(this.settings, this.currentDatabase, game).onRequestEditGameScreen(this.currentLanguage, Language.isRightToLeft(this.currentLanguage));
    }

    @Override
    public void onAcceptAddGameSaveAction(Game game) throws LauncherException {
        this.gamesMap.put(game.getName(), game);
        this.view.fillGameList(this.currentDatabase, this.getSortedGameList(), game.getName());
    }

    @Override
    public void onAcceptEditGameSaveAction(String oldName, Game game) throws LauncherException {
        this.gamesMap.remove(oldName);
        this.gamesMap.put(game.getName(), game);
        this.view.fillGameList(this.currentDatabase, this.getSortedGameList(), game.getName());
    }

    @Override
    public void onRequestRemoveGamesAction(Set<String> gameNames) throws LauncherException {
        block3: {
            HashSet<Game> games = new HashSet<Game>();
            gameNames.forEach(gameName -> {
                games.add(this.gamesMap.get(gameName));
                this.gamesMap.remove(gameName);
            });
            try {
                this.launcherPersistence.getGamePersister().deleteGames(games, this.currentDatabase);
            }
            catch (GamePersistenceException gpe) {
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_NOT_FOUND)) break block3;
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, this.currentDatabase);
                }
                throw new LauncherException(LauncherExceptionCode.ERR_IO);
            }
        }
        this.view.updateGameCount(this.gamesMap.size());
    }

    @Override
    public void onSelectGames(Set<String> gameNames) {
        if (this.currentDatabase == null) {
            this.resetAll();
        } else if (gameNames == null || gameNames.size() != 1) {
            this.view.showGameScreenshots(null, null);
            this.view.enableButtons(false, true, true, false, false);
            this.view.enableSoundIndicators(false, false, false, false, false, false, false, false);
            this.view.enableGenerationIndicators(false, false, false, false);
        } else {
            Game game = this.gamesMap.get(gameNames.iterator().next());
            String screenshot1 = null;
            String screenshot2 = null;
            if (game != null) {
                String screenshotsPath = this.settings.getScreenshotsFullPath();
                if (screenshotsPath != null) {
                    int msxGenID = game.getMsxGenID();
                    if (msxGenID > 0) {
                        StringBuilder screenshot1Filename = new StringBuilder(Utils.getString(msxGenID)).append(SCREENSHOT1_SUFFIX);
                        String screenshotSuffix = game.getScreenshotSuffix();
                        if (screenshotSuffix != null) {
                            screenshot1Filename.append(screenshotSuffix);
                        }
                        screenshot1Filename.append(SCREENSHOT_EXT);
                        File screenshot1File = new File(screenshotsPath, screenshot1Filename.toString());
                        if (screenshot1File.isFile()) {
                            screenshot1 = screenshot1File.toString();
                            StringBuilder screenshot2Filename = new StringBuilder(Utils.getString(msxGenID)).append(SCREENSHOT2_SUFFIX);
                            if (screenshotSuffix != null) {
                                screenshot2Filename.append(screenshotSuffix);
                            }
                            screenshot2Filename.append(SCREENSHOT_EXT);
                            File screenshot2File = new File(screenshotsPath, screenshot2Filename.toString());
                            if (screenshot2File.isFile()) {
                                screenshot2 = screenshot2File.toString();
                            }
                        }
                    }
                    this.view.showGameScreenshots(screenshot1, screenshot2);
                } else {
                    this.view.showGameScreenshots(null, null);
                }
                this.view.enableButtons(true, true, true, true, game.getInfo() != null);
                this.view.enableSoundIndicators(game.isPSG(), game.isSCC(), game.isSCCI(), game.isPCM(), game.isMSXMUSIC(), game.isMSXAUDIO(), game.isMoonsound(), game.isMIDI());
                this.view.enableGenerationIndicators(game.isMSX(), game.isMSX2(), game.isMSX2Plus(), game.isTurboR());
            }
        }
    }

    @Override
    public void resetAll() {
        this.view.showGameScreenshots(null, null);
        this.view.enableButtons(false, false, this.currentDatabase != null, false, false);
        this.view.enableSoundIndicators(false, false, false, false, false, false, false, false);
        this.view.enableGenerationIndicators(false, false, false, false);
    }

    @Override
    public void onViewUpdatedDatabase(String database) throws LauncherException {
        if (database != null) {
            this.currentDatabase = database;
        }
        if (!this.databases.contains(this.currentDatabase)) {
            this.databases.add(this.currentDatabase);
        }
        this.populateGameList();
    }

    @Override
    public void onRequestFillDatabaseScreen() throws LauncherException {
        ((ScannerPresenter)this.scannerPresenterFactory.get()).onRequestFillDatabaseScreen(this.databases, this.currentDatabase, this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestGameInfo(String gameName) throws LauncherException {
        String gameInfo;
        Game game = this.gamesMap.get(gameName);
        if (game != null && (gameInfo = game.getInfo()) != null) {
            MainPresenterImpl.startBrowser(gameInfo, LauncherExceptionCode.ERR_CANNOT_VIEW_GAMEINFO);
        }
    }

    @Override
    public void onRequestAboutScreen() {
        String extraDataVersion = null;
        try {
            extraDataVersion = this.extraDataGetter.getExtraDataFileVersion();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String screenshotsPath = null;
        try {
            screenshotsPath = this.launcherPersistence.getSettingsPersister().getSettings().getScreenshotsFullPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String screenshotsVersion = VersionUtils.getScreenshotsVersion(screenshotsPath);
        this.view.displayAbout(this.currentLanguage, Language.isRightToLeft(this.currentLanguage), extraDataVersion, screenshotsVersion);
    }

    @Override
    public Set<String> onRequestMoveGamesScreen(Set<String> gameNames, String oldDatabase) {
        HashSet<String> targetDatabases = new HashSet<String>(this.databases);
        targetDatabases.remove(this.currentDatabase);
        return this.view.displayAndGetMoveGames(this.currentLanguage, gameNames, oldDatabase, targetDatabases, Language.isRightToLeft(this.currentLanguage));
    }

    @Override
    public Set<String> onRequestMoveGamesAction(Set<String> gameNames, String oldDatabase, String newDatabase) throws LauncherException {
        HashSet<Game> games = new HashSet<Game>();
        gameNames.forEach(gameName -> games.add(this.gamesMap.get(gameName)));
        HashSet<String> movedGameNames = new HashSet<String>();
        try {
            Set<Game> movedGames = this.launcherPersistence.getGamePersister().moveGames(games, oldDatabase, newDatabase, new MoveGameActionDecider(this.view, this.currentLanguage, Language.isRightToLeft(this.currentLanguage)));
            movedGames.forEach(movedGame -> {
                movedGameNames.add(movedGame.getName());
                this.gamesMap.remove(movedGame.getName());
            });
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_NOT_FOUND);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_NULL_NAME)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_WITH_NULL_NAME);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        this.view.updateGameCount(this.gamesMap.size());
        return movedGameNames;
    }

    @Override
    public void onRequestCreateEmptyDatabaseScreen() {
        this.view.displayCreateEmptyDatabase(this.currentLanguage, Language.isRightToLeft(this.currentLanguage));
    }

    @Override
    public void onRequestCreateEmptyDatabaseAction(String newDatabase) throws LauncherException {
        try {
            this.launcherPersistence.getGamePersister().createDatabase(newDatabase);
            this.databases.add(newDatabase);
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NULL_NAME)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NULL_NAME);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_ALREADY_EXISTS, newDatabase);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestHelpFile() throws LauncherException {
        String helpFileFullPath = new File(this.helpFileDirectory, "README.html").getAbsolutePath();
        MainPresenterImpl.startBrowser(helpFileFullPath, LauncherExceptionCode.ERR_CANNOT_VIEW_HELP_FILE);
    }

    @Override
    public void onRequestLocateFile(String gameName) throws LauncherException {
        Game game = this.gamesMap.get(gameName);
        File file = new File(FileTypeUtils.getMainFile(game.getRomA(), game.getRomB(), game.getDiskA(), game.getDiskB(), game.getTape(), game.getHarddisk(), game.getLaserdisc(), game.getTclScript()));
        try {
            this.fileLocator.locateFile(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_LOCATE_FILE);
        }
    }

    @Override
    public void onRequestAddFavorite(String gameName, String database) throws LauncherException {
        block2: {
            try {
                this.launcherPersistence.getFavoritePersister().addFavorite(new DatabaseItem(gameName, database));
            }
            catch (FavoritePersistenceException lpe) {
                if (lpe.getIssue().equals((Object)FavoritePersistenceExceptionIssue.FAVORITE_ALREADY_EXISTS)) break block2;
                throw new LauncherException(LauncherExceptionCode.ERR_IO);
            }
        }
    }

    @Override
    public void onRequestFindRelated(String gameName) throws LauncherException {
        ((RelatedGamesPresenter)this.relatedGamesPresenterFactory.get()).onRequestRelatedGamesScreen(this.gamesMap.get(gameName), this.repositoryInfoMap, this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestListOfFavorites() {
        TreeSet<DatabaseItem> favorites = new TreeSet<DatabaseItem>(new DatabaseItemComparator());
        favorites.addAll(this.launcherPersistence.getFavoritePersister().getFavorites());
        this.view.showFavoritesMenu(favorites);
    }

    @Override
    public void onRequestDatabasesList() {
        this.view.showDatabasesList(this.databases);
    }

    @Override
    public void onSelectDatabaseItem(DatabaseItem databaseItem) throws LauncherException {
        this.onSelectDatabase(databaseItem.getDatabase());
        this.view.highlightGame(databaseItem.getGameName());
    }

    @Override
    public void onRequestDeleteFavoriteAction(DatabaseItem favorite) throws LauncherException {
        try {
            this.launcherPersistence.getFavoritePersister().deleteFavorite(favorite);
        }
        catch (FavoritePersistenceException fpe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestListOfSavedFilters() {
        Set<String> filterNames = this.launcherPersistence.getFiltersPersister().getFilterNames();
        this.view.showFiltersMenu(filterNames, this.currentFilterName != null, this.untitledFilter);
    }

    @Override
    public void onSelectFilter(String filterName) throws LauncherException {
        this.selectFilter(filterName);
    }

    @Override
    public void onSelectQuickFilter(Filter filter) throws LauncherException {
        this.currentFilter = Collections.singleton(filter);
        this.populateGameList();
        this.untitledFilter = true;
        this.view.setFilterNameLabelUntitled();
        this.view.displayFilterDetails(FilterFactory.getFilterMonikers(this.currentFilter));
    }

    @Override
    public void onRequestDeleteFilterAction(String filterName) throws LauncherException {
        try {
            this.launcherPersistence.getFiltersPersister().deleteFilter(filterName);
            if (filterName.equals(this.currentFilterName)) {
                this.selectFilter(null);
            }
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestAddFilterScreen() throws LauncherException {
        this.filterEditMode = false;
        ((FilterEditingPresenter)this.filterEditingPresenterFactory.get()).onRequestAddFilterScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestEditFilterScreen(String filterName) throws LauncherException {
        Set<Filter> filter = null;
        if (filterName == null) {
            filter = this.currentFilter;
        } else {
            try {
                filter = this.launcherPersistence.getFiltersPersister().getFilter(filterName);
            }
            catch (FilterSetNotFoundException fsnfe) {
                throw new LauncherException(LauncherExceptionCode.ERR_IO);
            }
        }
        this.filterEditMode = true;
        ((FilterEditingPresenter)this.filterEditingPresenterFactory.get()).onRequestEditFilterScreen(this.currentLanguage, this.currentRightToLeft, filterName, filter);
    }

    @Override
    public void onApplyFilter(Set<Filter> filter) throws LauncherException {
        this.currentFilter = filter;
        this.populateGameList();
        if (!this.filterEditMode) {
            if (!filter.isEmpty()) {
                this.untitledFilter = true;
                this.view.setFilterNameLabelUntitled();
            } else {
                this.untitledFilter = false;
                this.view.updateFilterNameLabel(null);
            }
            this.view.displayFilterDetails(FilterFactory.getFilterMonikers(this.currentFilter));
        }
    }

    @Override
    public void onRequestUpdateFilterName(String filterName) {
        this.updateFilterName(filterName);
    }

    @Override
    public void onRequestSetFilterNameUntitled() {
        this.untitledFilter = true;
        this.view.setFilterNameLabelUntitled();
        this.view.displayFilterDetails(FilterFactory.getFilterMonikers(this.currentFilter));
    }

    @Override
    public void onRequestShowProperties(String gameName) {
        ((GamePropertiesPresenter)this.gamePropertiesPresenterFactory.get()).onRequestGamePropertiesScreen(this.gamesMap.get(gameName), this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public int onRequestUpdateAllDatabases() throws LauncherException {
        Map<String, ExtraData> extraDataMap = null;
        int numberUpdatedProfiles = 0;
        try {
            extraDataMap = this.extraDataGetter.getExtraData();
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        try {
            numberUpdatedProfiles = this.launcherPersistence.getGamePersister().updateGameExtraDataInDatabases(extraDataMap);
        }
        catch (GamePersistenceException gpe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        return numberUpdatedProfiles;
    }

    @Override
    public void onRequestImportBlueMSXLauncherDatabasesScreen() throws LauncherException {
        ((BlueMSXLauncherDatabasesImporterPresenter)this.blueMSXLauncherImporterPresenterFactory.get()).onRequestImportBlueMSXLauncherDatabasesScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onAcceptImportBlueMSXLauncherDatabasesAction(Set<String> importedDatabases) throws LauncherException {
        for (String importedDatabase : importedDatabases) {
            if (this.databases.contains(importedDatabase)) continue;
            this.databases.add(importedDatabase);
        }
    }

    @Override
    public void onRequestDatabaseManagerScreen() throws LauncherException {
        this.databaseManagerPresenterFactory.create(this.databases, this.currentLanguage, this.currentRightToLeft).onRequestDatabaseManagerScreen();
    }

    @Override
    public void onRequestDeleteDatabaseAction(String database) {
        this.databases.remove(database);
        if (this.currentDatabase != null && this.currentDatabase.equals(database)) {
            this.gamesMap.clear();
            this.currentDatabase = null;
        }
        this.view.removeDatabase(database);
    }

    @Override
    public void onRequestRenameDatabaseAction(String oldDatabase, String newDatabase) {
        if (this.currentDatabase != null && this.currentDatabase.equals(oldDatabase)) {
            this.currentDatabase = newDatabase;
        }
        this.view.renameDatabase(oldDatabase, newDatabase);
        this.databases.add(newDatabase);
        this.databases.remove(oldDatabase);
    }

    @Override
    public void onRequestUpdatesChecker() throws LauncherException {
        ((UpdateCheckerPresenter)this.updateCheckerPresenterFactory.get()).onRequestCheckForUpdatesScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestActivityViewerScreen() {
        ((ActivityViewerPresenter)this.activityViewerPresenterFactory.get()).onRequestActivityViewerScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestPatcherScreen() {
        ((PatcherPresenter)this.patcherPresenterFactory.get()).onRequestIPSPatcherScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestLHAExtractorScreen() {
        ((LHAExtractorPresenter)this.lhaExtractorPresenterFactory.get()).onRequestLHAExtractorScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestMachineUpdateScreen() throws LauncherException {
        this.machineUpdatePresenterFactory.create(this.currentDatabase).onRequestMachineUpdateScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestExit() {
        try {
            this.launcherPersistence.shutdown();
        }
        catch (LauncherPersistenceException launcherPersistenceException) {
            // empty catch block
        }
    }

    @Override
    public void onRequestAddDraggedAndDroppedGamesScreen(File[] files) throws LauncherException {
        if (this.currentDatabase != null) {
            this.draggedAndDroppedGamesPresenterFactory.create(this.currentDatabase, files).onRequestAddDraggedAndDroppedGamesScreen(this.currentLanguage, Language.isRightToLeft(this.currentLanguage));
        }
    }

    @Override
    public Set<DatabaseItem> onRequestSearchMatches(String searchString) {
        TreeSet<DatabaseItem> matches = new TreeSet<DatabaseItem>(new DatabaseItemComparator());
        matches.addAll(this.launcherPersistence.getGameFinder().find(searchString, 10));
        return matches;
    }

    @Override
    public void onUpdateExtraData() throws LauncherException {
        this.initializeRepositoryInfoMap();
        this.onViewUpdatedDatabase(null);
    }

    @Override
    public void onRequestNewsList() {
        try {
            this.feedServicePresenter.onRequestNewsList();
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
        }
    }

    private static void startBrowser(String uriString, LauncherExceptionCode errCodeIfNotFound) throws LauncherException {
        URI uri;
        File file = new File(uriString);
        if (file.exists()) {
            uri = file.toURI();
        } else {
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException use) {
                throw new LauncherException(errCodeIfNotFound);
            }
        }
        try {
            ExternalLinksUtils.startBrowser(uri);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    private void setLanguageParameters(Language language) {
        this.currentLanguage = language;
        if (this.currentLanguage == null) {
            Locale locale = Locale.getDefault();
            this.currentLanguage = Language.fromLocale(locale.getLanguage() + "_" + locale.getCountry());
            if (this.currentLanguage == null) {
                this.currentLanguage = Language.ENGLISH;
            }
            this.currentLanguageCode = DEFAULT_SYSTEM_LANGUAGE;
        } else {
            this.currentLanguageCode = this.currentLanguage.toString();
        }
        this.currentRightToLeft = Language.isRightToLeft(this.currentLanguage);
    }

    private Set<GameLabel> getSortedGameList() {
        LinkedHashSet<GameLabel> sortedList = new LinkedHashSet<GameLabel>();
        if (this.gamesMap != null) {
            this.gamesMap.entrySet().stream().map(Map.Entry::getValue).sorted((game1, game2) -> game1.getName().compareToIgnoreCase(game2.getName())).forEach(game -> sortedList.add(this.getGameLabel((Game)game)));
        }
        return sortedList;
    }

    private GameLabel getGameLabel(Game game) {
        RepositoryGame repositoryGame;
        String company = null;
        String year = null;
        if (this.repositoryInfoMap != null && (repositoryGame = this.repositoryInfoMap.get(game.getSha1Code())) != null) {
            company = repositoryGame.getCompany();
            year = repositoryGame.getYear();
        }
        return new GameLabel(game.getName(), company, year, game.getSize(), MainPresenterImpl.getGameMedium(game));
    }

    private static Medium getGameMedium(Game game) {
        Medium medium = null;
        if (game.isROM()) {
            medium = Medium.ROM;
        } else if (game.isDisk()) {
            medium = Medium.DISK;
        } else if (game.isHarddisk()) {
            medium = Medium.HARDDISK;
        } else if (game.isTape()) {
            medium = Medium.TAPE;
        } else if (game.isLaserdisc()) {
            medium = Medium.LASERDISC;
        } else if (game.isScript()) {
            medium = Medium.SCRIPT;
        }
        return medium;
    }

    private void populateGameList() throws LauncherException {
        try {
            this.retrieveDatabaseGames();
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, this.currentDatabase);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        this.view.fillGameList(this.currentDatabase, this.getSortedGameList(), null);
    }

    private void retrieveDatabaseGames() throws GamePersistenceException {
        Set<Game> games = this.launcherPersistence.getGamePersister().getGames(this.currentDatabase);
        if (this.currentFilter == null) {
            this.setGameMap(games);
        } else {
            HashSet<Game> filteredGames = new HashSet<Game>();
            games.stream().filter(game -> !this.isFiltered((Game)game)).forEach(filteredGames::add);
            this.setGameMap(filteredGames);
        }
    }

    private boolean isFiltered(Game game) {
        HashMap<String, Boolean> filtersByType = new HashMap<String, Boolean>();
        for (Filter filter : this.currentFilter) {
            String type = filter.getClass().getSimpleName();
            Boolean existingFilterValue = (Boolean)filtersByType.get(type);
            if (existingFilterValue == null) {
                filtersByType.put(type, true);
                existingFilterValue = true;
            }
            filtersByType.put(type, existingFilterValue != false && filter.isFiltered(game, this.repositoryInfoMap == null ? null : this.repositoryInfoMap.get(game.getSha1Code())));
        }
        return filtersByType.entrySet().stream().map(Map.Entry::getValue).anyMatch(v -> v);
    }

    private void setGameMap(Set<Game> games) {
        this.gamesMap = games.stream().collect(Collectors.toMap(Game::getName, game -> game));
    }

    private void initializeRepositoryInfoMap() {
        try {
            this.repositoryInfoMap = this.repositoryData.getRepositoryInfo();
        }
        catch (IOException ioe) {
            this.repositoryInfoMap = null;
        }
    }

    private void selectFilter(String filterName) throws LauncherException {
        if (filterName == null) {
            this.currentFilter = null;
        } else {
            try {
                this.currentFilter = this.launcherPersistence.getFiltersPersister().getFilter(filterName);
            }
            catch (FilterSetNotFoundException filterSetNotFoundException) {
                // empty catch block
            }
        }
        if (!Utils.isEmpty(this.currentDatabase)) {
            this.populateGameList();
            this.updateFilterName(filterName);
        }
    }

    private void updateFilterName(String filterName) {
        this.untitledFilter = false;
        this.currentFilterName = filterName;
        this.view.updateFilterNameLabel(filterName);
        this.view.displayFilterDetails(FilterFactory.getFilterMonikers(this.currentFilter));
    }

    private class DatabaseItemComparator
    implements Comparator<DatabaseItem> {
        private DatabaseItemComparator() {
        }

        @Override
        public int compare(DatabaseItem fav1, DatabaseItem fav2) {
            String gameName2;
            String gameName1 = fav1.getGameName();
            int sComp = gameName1.compareToIgnoreCase(gameName2 = fav2.getGameName());
            if (sComp != 0) {
                return sComp;
            }
            String database1 = fav1.getDatabase();
            String database2 = fav2.getDatabase();
            return database1.compareToIgnoreCase(database2);
        }
    }
}

